/* global define */
define(["lib/Zoot", "src/math/Vec2", "src/math/Mat3", "lodash", "src/utils", "src/build/VisualMarks"],
function (Z, vec2, mat3, lodash, utils, VisualMarks) {
	"use strict";

	var HighlightType = {
		kTouched : 0,
		kAutomated : 1,
		kAutomatedTranslation : 2,
		kAutomatedLinear : 3
	};

	function forEachShownLayer (self, args, fn) {
		var classIndex = 0,
			layerIndex = 0,
			layerNum = 0;
		args.forEachLayerInTree(function (sdkLayer) {
			var layer = sdkLayer.privateLayer;
			if (layer.getWarpWithParent()) return;
			if (layerIndex+1 < self.layerStart) { // layerIndex is zero-based and layerStart is one-based.
				layerIndex += 1;
				return;
			}

			if (classIndex+1 > self.layerNum) return false;

			utils.assert(classIndex < 12);

			fn(layer, classIndex, layerIndex);

			classIndex += 1;
			layerIndex += 1;
			layerNum += 1;
		});
	}


	function update (self, args) {
		var markIndex = 0, highlightType = args.getParam("highlightType");

		forEachShownLayer(self, args, function (layer) {
		    var handleTree = layer.getHandleTreeArray(),
				// FIXME: gatherHandleLeafMatrixArray() no longer supported.  reimplement when needed.
                aMatLayer_Leaf = layer.gatherHandleLeafMatrixArray("layer", handleTree),
				aHandles = layer.gatherHandleLeafArray(),
				matScene_Layer = args.getLayerMatrixRelativeToScene(layer), i, matLayer_Leaf, mark, h,
				highlightB = false;

		    utils.assert(aHandles.length === aMatLayer_Leaf.length);

			for (i = 0; i < aMatLayer_Leaf.length; i++) {
				matLayer_Leaf = aMatLayer_Leaf[i];
				mark = self.leafMarks.getMarkAtIndex(markIndex);
				mark.setMatrix(mat3.multiply(matScene_Layer, matLayer_Leaf));
				h = aHandles[i].getOriginLeafProxy();
				// FIXME: isTouched() and the rest no longer supported. reimplement if needed
				// switch (highlightType) {
				// 	case HighlightType.kTouched:
				// 		highlightB = h.isTouched();
				// 		break;
				// 	case HighlightType.kAutomated:
				// 		highlightB = h.isAutomated();
				// 		break;
				// 	case HighlightType.kAutomatedTranslation:
				// 		highlightB = h.isAutomatedTranslation();
				// 		break;
				// 	case HighlightType.kAutomatedLinear:
				// 		highlightB = h.isAutomatedLinear();
				// 		break;						
				// 	default:
				// 		utils.assert(false, "unknown highlight type.");
				// 		break;
				// }
				mark.findNode("stroke").setAlpha(highlightB ? 1.0 : 0.0);
				markIndex += 1;
			}
		});

	}

	function create (self, args) {
		self.leafMarks = new VisualMarks({ opacity : self.opacity / 100 });

		forEachShownLayer(self, args, function (layer, classIndex) {
			// FIXME: gatherHandleLeafMatrixArray() no longer supported.  reimplement when needed.
			var aMatLayer_Leaf = layer.gatherHandleLeafMatrixArray("layer"),
				matScene_Layer = args.getLayerMatrixRelativeToScene(layer);

			aMatLayer_Leaf.forEach(function (matLayer_Leaf) {
				var mark = self.leafMarks.square(self.markSize, classIndex);
				self.leafMarks.insertMark(mark);
				mark.setMatrix(mat3.multiply(matScene_Layer, matLayer_Leaf));
			});

		});

		self.leafMarks.addToDisplayItem(args.stageLayer.privateLayer.getTrackItem());
	}

	function remove (self, args) {
		if (self.leafMarks) {
			self.leafMarks.removeFromDisplayItem(args.stageLayer.privateLayer.getTrackItem());
			self.leafMarks = null;
		}
	}

	return {
		about: "$$$/private/animal/Behavior/ShowWarperHandles/About=ShowWarperHandles, (c) 2014.",
		description: "$$$/private/animal/Behavior/ShowWarperHandles/Desc=Shows all warper handles",
		uiName: 	"$$$/private/animal/Behavior/ShowWarperHandles/UIName=Show Warper Handles",
		defaultArmedForRecordOn: true,
		hideInBehaviorList: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			var params = [
				{
					id : "markSize",
					type : "slider",
					uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/markSize=Mark Size",
					min : 1,
					max : 100,
					dephault : 20
				},
				{
					id : "opacity",
					type : "slider",
					uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/opacity=Opacity",
					uiUnits : "%",
					min : 0,
					max : 100,
					precision : 0,
					dephault : 50
				},
				{
					id: "highlightType",   
					type:"enum",
					uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/highlightType=Highlight",
					items: [
						{ id: HighlightType.kTouched, uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/highlightType/Touched=Touched" },
						{ id: HighlightType.kAutomated, uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/highlightType/Automated=Automated" },
						{ id: HighlightType.kAutomatedTranslation, uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/highlightType/AutomatedTranslation=Automated Translation" },
						{ id: HighlightType.kAutomatedLinear, uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/highlightType/AutomatedLinear=Automated Linear" }
					],
					dephault: HighlightType.kTouched
				},
				{
					id : "layerStart",
					type : "slider",
					uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/layerStart=First Layer to Show",
					min : 1,
					max : 100,
					dephault : 1
				},
				{
					id : "layerNum",
					type : "slider",
					uiName: "$$$/private/animal/Behavior/ShowWarperHandles/Parameter/layerNum=Number of Layers",
					min : 1,
					max : 12,
					dephault : 12
				}
			];

			return params;
		},

		onCreateBackStageBehavior: function (/*self*/) {
			return { order: 22.0, importance : 0.0 }; // must come after others
		},

		onCreateStageBehavior: function (/*self, args*/) {
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var markSize = args.getParam("markSize"),
				opacity = args.getParam("opacity"),
				layerStart = args.getParam("layerStart"),
				layerNum = args.getParam("layerNum");

			if (
				markSize !== self.markSize ||
				opacity !== self.opacity ||
				layerStart !== self.layerStart ||
				layerNum !== self.layerNum
			) {
				remove(self, args);
			}

			if (self.leafMarks) {
				update(self, args);
			} else {
				self.markSize = markSize;
				self.opacity = opacity;
				self.layerStart = layerStart;
				self.layerNum = layerNum;
				create(self, args);
			}
		}

	}; // end of object being returned
});
